/* 
 * arch/arm/mach-uniphier/include/mach/nand_partition.h
 *
 * Copyright (C) 2011 Panasonic Corporation
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * Generated by   NANDP_GenerationTool.xls
 */

#ifndef	__ASM_ARCH_NAND_PARTITION_H
#define	__ASM_ARCH_NAND_PARTITION_H
#include <linux/config.h>

#if defined(CONFIG_MTD_NAND_MAP_V1)
#if defined(CONFIG_MACH_MN2WS0251_REF) || defined(CONFIG_MACH_MN2WS0270_REF)
#if (CONFIG_MTD_NAND_MN2WS_CHIP_SIZE_GBIT==2)
/* [V1-MAP SYSTEM] Size=2Gb */
		static struct mtd_partition nand_gpbc_partition_info[] = {
			{ .offset = 0x00000000, .size = 0x00100000, .name = "nand_2ndboot", },
			{ .offset = 0x00100000, .size = 0x00100000, .name = "stm_nand_2ndboot", },
			{ .offset = 0x00200000, .size = 0x00020000, .name = "nand_swupdate_flag1", },
			{ .offset = 0x00220000, .size = 0x00020000, .name = "nand_swupdate_flag2", },
			{ .offset = 0x00240000, .size = 0x00020000, .name = "nand_stm_main", },
			{ .offset = 0x00260000, .size = 0x00040000, .name = "nand_3rdboot", },
			{ .offset = 0x002a0000, .size = 0x00040000, .name = "nand_uboot", },
			{ .offset = 0x002e0000, .size = 0x00800000, .name = "nand_ucode", },
			{ .offset = 0x00ae0000, .size = 0x00400000, .name = "nand_kernel", },
			{ .offset = 0x00ee0000, .size = 0x00800000, .name = "nand_rootfs", },
			{ .offset = 0x016e0000, .size = 0x05800000, .name = "nand_fs_usr", },
			{ .offset = 0x06ee0000, .size = 0x06CA0000, .name = "nand_bank1", },
			{ .offset = 0x0db80000, .size = 0x00020000, .name = "nand_uboot_env", },
			{ .offset = 0x0dba0000, .size = 0x01000000, .name = "nand_fs_nv", },
			{ .offset = 0x0eba0000, .size = 0x00720000, .name = "nand_reserved", },
			{ .offset = 0x0f2c0000, .size = 0x00100000, .name = "nand_eeprom", },
			{ .offset = 0x0f3c0000, .size = 0x00C40000, .name = "nand_sys_bbm", },
		};
#if defined(CONFIG_NANDBOOT_BANKCHOICE)
		static struct mtd_partition nand_gpbc_partition_info1[] = {
			{ .offset = 0x00000000, .size = 0x00100000, .name = "nand_2ndboot", },
			{ .offset = 0x00100000, .size = 0x00100000, .name = "stm_nand_2ndboot", },
			{ .offset = 0x00200000, .size = 0x00020000, .name = "nand_swupdate_flag1", },
			{ .offset = 0x00220000, .size = 0x00020000, .name = "nand_swupdate_flag2", },
			{ .offset = 0x06EE0000, .size = 0x00020000, .name = "nand_stm_main", },
			{ .offset = 0x06F00000, .size = 0x00040000, .name = "nand_3rdboot", },
			{ .offset = 0x06F40000, .size = 0x00040000, .name = "nand_uboot", },
			{ .offset = 0x06F80000, .size = 0x00800000, .name = "nand_ucode", },
			{ .offset = 0x07780000, .size = 0x00400000, .name = "nand_kernel", },
			{ .offset = 0x07b80000, .size = 0x00800000, .name = "nand_rootfs", },
			{ .offset = 0x08380000, .size = 0x05800000, .name = "nand_fs_usr", },
			{ .offset = 0x00240000, .size = 0x06CA0000, .name = "nand_bank1", },
			{ .offset = 0x0db80000, .size = 0x00020000, .name = "nand_uboot_env", },
			{ .offset = 0x0dba0000, .size = 0x01000000, .name = "nand_fs_nv", },
			{ .offset = 0x0eba0000, .size = 0x00720000, .name = "nand_reserved", },
			{ .offset = 0x0f2c0000, .size = 0x00100000, .name = "nand_eeprom", },
			{ .offset = 0x0f3c0000, .size = 0x00C40000, .name = "nand_sys_bbm", },
		};
#endif  //defined(CONFIG_NANDBOOT_BANKCHOICE)
#elif (CONFIG_MTD_NAND_MN2WS_CHIP_SIZE_GBIT==4)
/* [V1-MAP SYSTEM] Size=4Gb */
		static struct mtd_partition nand_gpbc_partition_info[] = {
			{ .offset = 0x00000000, .size = 0x00100000, .name = "nand_2ndboot", },
			{ .offset = 0x00100000, .size = 0x00100000, .name = "stm_nand_2ndboot", },
			{ .offset = 0x00200000, .size = 0x00020000, .name = "nand_swupdate_flag1", },
			{ .offset = 0x00220000, .size = 0x00020000, .name = "nand_swupdate_flag2", },
			{ .offset = 0x00240000, .size = 0x00020000, .name = "nand_stm_main", },
			{ .offset = 0x00260000, .size = 0x00040000, .name = "nand_3rdboot", },
			{ .offset = 0x002a0000, .size = 0x00040000, .name = "nand_uboot", },
			{ .offset = 0x002e0000, .size = 0x00800000, .name = "nand_ucode", },
			{ .offset = 0x00ae0000, .size = 0x00400000, .name = "nand_kernel", },
			{ .offset = 0x00ee0000, .size = 0x00800000, .name = "nand_rootfs", },
			{ .offset = 0x016e0000, .size = 0x05800000, .name = "nand_fs_usr", },
			{ .offset = 0x06ee0000, .size = 0x06CA0000, .name = "nand_bank1", },
			{ .offset = 0x0db80000, .size = 0x00020000, .name = "nand_uboot_env", },
			{ .offset = 0x0dba0000, .size = 0x01000000, .name = "nand_fs_nv", },
			{ .offset = 0x0eba0000, .size = 0x10720000, .name = "nand_reserved", },
			{ .offset = 0x1f2c0000, .size = 0x00100000, .name = "nand_eeprom", },
			{ .offset = 0x1f3c0000, .size = 0x00C40000, .name = "nand_sys_bbm", },
		};
#if defined(CONFIG_NANDBOOT_BANKCHOICE)
		static struct mtd_partition nand_gpbc_partition_info1[] = {
			{ .offset = 0x00000000, .size = 0x00100000, .name = "nand_2ndboot", },
			{ .offset = 0x00100000, .size = 0x00100000, .name = "stm_nand_2ndboot", },
			{ .offset = 0x00200000, .size = 0x00020000, .name = "nand_swupdate_flag1", },
			{ .offset = 0x00220000, .size = 0x00020000, .name = "nand_swupdate_flag2", },
			{ .offset = 0x06EE0000, .size = 0x00020000, .name = "nand_stm_main", },
			{ .offset = 0x06F00000, .size = 0x00040000, .name = "nand_3rdboot", },
			{ .offset = 0x06F40000, .size = 0x00040000, .name = "nand_uboot", },
			{ .offset = 0x06F80000, .size = 0x00800000, .name = "nand_ucode", },
			{ .offset = 0x07780000, .size = 0x00400000, .name = "nand_kernel", },
			{ .offset = 0x07b80000, .size = 0x00800000, .name = "nand_rootfs", },
			{ .offset = 0x08380000, .size = 0x05800000, .name = "nand_fs_usr", },
			{ .offset = 0x00240000, .size = 0x06CA0000, .name = "nand_bank1", },
			{ .offset = 0x0db80000, .size = 0x00020000, .name = "nand_uboot_env", },
			{ .offset = 0x0dba0000, .size = 0x01000000, .name = "nand_fs_nv", },
			{ .offset = 0x0eba0000, .size = 0x10720000, .name = "nand_reserved", },
			{ .offset = 0x1f2c0000, .size = 0x00100000, .name = "nand_eeprom", },
			{ .offset = 0x1f3c0000, .size = 0x00C40000, .name = "nand_sys_bbm", },
		};
#endif  //defined(CONFIG_NANDBOOT_BANKCHOICE)
#elif (CONFIG_MTD_NAND_MN2WS_CHIP_SIZE_GBIT==16)
/* [V1-MAP SYSTEM] Size=16Gb */
		static struct mtd_partition nand_gpbc_partition_info[] = {
			{ .offset = 0x00000000, .size = 0x00200000, .name = "nand_2ndboot", },
			{ .offset = 0x00200000, .size = 0x00200000, .name = "stm_nand_2ndboot", },
			{ .offset = 0x00400000, .size = 0x00040000, .name = "nand_swupdate_flag1", },
			{ .offset = 0x00440000, .size = 0x00040000, .name = "nand_swupdate_flag2", },
			{ .offset = 0x00480000, .size = 0x00040000, .name = "nand_stm_main", },
			{ .offset = 0x004C0000, .size = 0x00080000, .name = "nand_3rdboot", },
			{ .offset = 0x00540000, .size = 0x00080000, .name = "nand_uboot", },
			{ .offset = 0x005c0000, .size = 0x00800000, .name = "nand_ucode", },
			{ .offset = 0x00dc0000, .size = 0x00400000, .name = "nand_kernel", },
			{ .offset = 0x011c0000, .size = 0x00800000, .name = "nand_rootfs", },
			{ .offset = 0x019c0000, .size = 0x05800000, .name = "nand_fs_usr", },
			{ .offset = 0x071c0000, .size = 0x06D40000, .name = "nand_bank1", },
			{ .offset = 0x0df00000, .size = 0x00040000, .name = "nand_uboot_env", },
			{ .offset = 0x0df40000, .size = 0x01000000, .name = "nand_fs_nv", },
			{ .offset = 0x0ef40000, .size = 0x2EFC0000, .name = "nand_reserved", },
			{ .offset = 0x3df00000, .size = 0x00100000, .name = "nand_eeprom", },
			{ .offset = 0x3e000000, .size = 0x02000000, .name = "nand_sys_bbm1", },
#if (CONFIG_MTD_NAND_MN2WS_CHIP_BANK == 2)
			{ .offset = 0x40000000, .size = 0x3E000000, .name = "nand_sys_reserved", },
			{ .offset = 0x7e000000, .size = 0x02000000, .name = "nand_sys_bbm2", },
#endif
		};
#if defined(CONFIG_NANDBOOT_BANKCHOICE)
		static struct mtd_partition nand_gpbc_partition_info1[] = {
			{ .offset = 0x00000000, .size = 0x00200000, .name = "nand_2ndboot", },
			{ .offset = 0x00200000, .size = 0x00200000, .name = "stm_nand_2ndboot", },
			{ .offset = 0x00400000, .size = 0x00040000, .name = "nand_swupdate_flag1", },
			{ .offset = 0x00440000, .size = 0x00040000, .name = "nand_swupdate_flag2", },
			{ .offset = 0x071C0000, .size = 0x00040000, .name = "nand_stm_main", },
			{ .offset = 0x07200000, .size = 0x00080000, .name = "nand_3rdboot", },
			{ .offset = 0x07280000, .size = 0x00080000, .name = "nand_uboot", },
			{ .offset = 0x07300000, .size = 0x00800000, .name = "nand_ucode", },
			{ .offset = 0x07B00000, .size = 0x00400000, .name = "nand_kernel", },
			{ .offset = 0x07F00000, .size = 0x00800000, .name = "nand_rootfs", },
			{ .offset = 0x08700000, .size = 0x05800000, .name = "nand_fs_usr", },
			{ .offset = 0x00480000, .size = 0x06D40000, .name = "nand_bank1", },
			{ .offset = 0x0df00000, .size = 0x00040000, .name = "nand_uboot_env", },
			{ .offset = 0x0df40000, .size = 0x01000000, .name = "nand_fs_nv", },
			{ .offset = 0x0ef40000, .size = 0x2EFC0000, .name = "nand_reserved", },
			{ .offset = 0x3df00000, .size = 0x00100000, .name = "nand_eeprom", },
			{ .offset = 0x3e000000, .size = 0x02000000, .name = "nand_sys_bbm1", },
#if (CONFIG_MTD_NAND_MN2WS_CHIP_BANK == 2)
			{ .offset = 0x40000000, .size = 0x3E000000, .name = "nand_sys_reserved", },
			{ .offset = 0x7e000000, .size = 0x02000000, .name = "nand_sys_bbm2", },		
#endif
		};
#endif  //defined(CONFIG_NANDBOOT_BANKCHOICE)

#else
# error Unexpected NAND Size !!
#endif

#else  //defined(CONFIG_MACH_MN2WS0251_REF || defined(CONFIG_MACH_MN2WS0270_REF)
		static struct mtd_partition nand_gpbc_partition_info[] = {
			{ .offset = 0x00000000, .size = 0x00040000, .name = "nand_2ndboot", },
			{ .offset = 0x00040000, .size = 0x000C0000, .name = "nand_3rdboot", },
			{ .offset = 0x00100000, .size = 0x000C0000, .name = "nand_uboot", },
			{ .offset = 0x001c0000, .size = 0x00040000, .name = "nand_uboot_env", },
			{ .offset = 0x00200000, .size = 0x00A00000, .name = "nand_ucode", },
			{ .offset = 0x00c00000, .size = 0x00400000, .name = "nand_kernel", },
			{ .offset = 0x01000000, .size = 0x01000000, .name = "nand_rootfs", },
			{ .offset = 0x02000000, .size = 0x08000000, .name = "nand_fs_usr", },
			{ .offset = 0x0a000000, .size = 0x04000000, .name = "nand_fs_home", },
			{ .offset = 0x0e000000, .size = 0x04000000, .name = "nand_fs_nv", },
			{ .offset = 0x12000000, .size = 0x2B500000, .name = "nand_fs_reserved", },
			{ .offset = 0x3d500000, .size = 0x00100000, .name = "nand_fs_channel", },
			{ .offset = 0x3d600000, .size = 0x00100000, .name = "nand_misc", },
			{ .offset = 0x3d700000, .size = 0x00900000, .name = "nand_splashscreen", },
			{ .offset = 0x3e000000, .size = 0x02000000, .name = "nand_sys_bbm1", },
#if (CONFIG_MTD_NAND_MN2WS_CHIP_BANK == 2)
			{ .offset = 0x40000000, .size = 0x3E000000, .name = "nand_sys_reserved", },
			{ .offset = 0x7e000000, .size = 0x02000000, .name = "nand_sys_bbm2", },
#endif
		};
#endif //defined(CONFIG_MACH_MN2WS0251_REF || defined(CONFIG_MACH_MN2WS0270_REF)
#elif defined(CONFIG_MTD_NAND_MAP_V2)
#if (CONFIG_MTD_NAND_MN2WS_CHIP_SIZE_GBIT==2)
static struct mtd_partition nand_gpbc_partition_info[] = {
  { .offset = 0x00000000, .size = 0x00100000, .name = "nand_2ndboot", },
  { .offset = 0x00100000, .size = 0x00040000, .name = "v3rdboot", },
  { .offset = 0x00140000, .size = 0x00040000, .name = "vuboot", },
  { .offset = 0x00180000, .size = 0x00400000, .name = "vucode", },
  { .offset = 0x00580000, .size = 0x00a00000, .name = "vkernel", },
  { .offset = 0x00f80000, .size = 0x00020000, .name = "model_info", },
  { .offset = 0x00fa0000, .size = 0x00020000, .name = "swupdate_flag", },
  { .offset = 0x00fc0000, .size = 0x00040000, .name = "uboot_env", },
  { .offset = 0x01000000, .size = 0x000a0000, .name = "param", },

  { .offset = 0x010a0000, .size = 0x00040000, .name = "3rdboot_a", },
  { .offset = 0x010e0000, .size = 0x00040000, .name = "uboot_a", },
  { .offset = 0x01120000, .size = 0x00400000, .name = "ucode_a", },
  { .offset = 0x01520000, .size = 0x00400000, .name = "kernel_a", },
  { .offset = 0x01920000, .size = 0x00880000, .name = "rfs_a", },
  { .offset = 0x021a0000, .size = 0x03e80000, .name = "usr_a", },

  { .offset = 0x06020000, .size = 0x00040000, .name = "3rdboot_b", },
  { .offset = 0x06060000, .size = 0x00040000, .name = "uboot_b", },
  { .offset = 0x060a0000, .size = 0x00400000, .name = "ucode_b", },
  { .offset = 0x064a0000, .size = 0x00400000, .name = "kernel_b", },
  { .offset = 0x068a0000, .size = 0x00880000, .name = "rfs_b", },
  { .offset = 0x07120000, .size = 0x03e80000, .name = "usr_b", },

  { .offset = 0x0afa0000, .size = 0x00040000, .name = "3rd", },
  { .offset = 0x0afe0000, .size = 0x01e00000, .name = "sys_data", },
  { .offset = 0x0cde0000, .size = 0x00500000, .name = "usr_data", },
  { .offset = 0x0d2e0000, .size = 0x01e00000, .name = "ro_data", },
  { .offset = 0x0f0e0000, .size = 0x00700000, .name = "tmp", },
  { .offset = 0x0f7e0000, .size = 0x00020000, .name = "manual", },
  { .offset = 0x0f800000, .size = 0x00800000, .name = "sys_bbm", }
};

#if defined(CONFIG_NANDBOOT_BANKCHOICE)
static struct mtd_partition nand_gpbc_partition_info1[] = {
  { .offset = 0x00000000, .size = 0x00100000, .name = "nand_2ndboot", },
  { .offset = 0x00100000, .size = 0x00040000, .name = "v3rdboot", },
  { .offset = 0x00140000, .size = 0x00040000, .name = "vuboot", },
  { .offset = 0x00180000, .size = 0x00400000, .name = "vucode", },
  { .offset = 0x00580000, .size = 0x00a00000, .name = "vkernel", },
  { .offset = 0x00f80000, .size = 0x00020000, .name = "model_info", },
  { .offset = 0x00fa0000, .size = 0x00020000, .name = "swupdate_flag", },
  { .offset = 0x00fc0000, .size = 0x00040000, .name = "uboot_env", },
  { .offset = 0x01000000, .size = 0x000a0000, .name = "param", },

  { .offset = 0x010a0000, .size = 0x00040000, .name = "3rdboot_a", },
  { .offset = 0x010e0000, .size = 0x00040000, .name = "uboot_a", },
  { .offset = 0x01120000, .size = 0x00400000, .name = "ucode_a", },
  { .offset = 0x01520000, .size = 0x00400000, .name = "kernel_a", },
  { .offset = 0x01920000, .size = 0x00880000, .name = "rfs_a", },
  { .offset = 0x021a0000, .size = 0x03e80000, .name = "usr_a", },

  { .offset = 0x06020000, .size = 0x00040000, .name = "3rdboot_b", },
  { .offset = 0x06060000, .size = 0x00040000, .name = "uboot_b", },
  { .offset = 0x060a0000, .size = 0x00400000, .name = "ucode_b", },
  { .offset = 0x064a0000, .size = 0x00400000, .name = "kernel_b", },
  { .offset = 0x068a0000, .size = 0x00880000, .name = "rfs_b", },
  { .offset = 0x07120000, .size = 0x03e80000, .name = "usr_b", },

  { .offset = 0x0afa0000, .size = 0x00040000, .name = "3rd", },
  { .offset = 0x0afe0000, .size = 0x01e00000, .name = "sys_data", },
  { .offset = 0x0cde0000, .size = 0x00500000, .name = "usr_data", },
  { .offset = 0x0d2e0000, .size = 0x01e00000, .name = "ro_data", },
  { .offset = 0x0f0e0000, .size = 0x00700000, .name = "tmp", },
  { .offset = 0x0f7e0000, .size = 0x00020000, .name = "manual", },
  { .offset = 0x0f800000, .size = 0x00800000, .name = "sys_bbm", }
};
#endif

#elif (CONFIG_MTD_NAND_MN2WS_CHIP_SIZE_GBIT==4)
static struct mtd_partition nand_gpbc_partition_info[] = {
  { .offset = 0x00000000, .size = 0x00100000, .name = "nand_2ndboot", },
  { .offset = 0x00100000, .size = 0x00040000, .name = "v3rdboot", },
  { .offset = 0x00140000, .size = 0x00040000, .name = "vuboot", },
  { .offset = 0x00180000, .size = 0x00400000, .name = "vucode", },
  { .offset = 0x00580000, .size = 0x00a00000, .name = "vkernel", },
  { .offset = 0x00f80000, .size = 0x00020000, .name = "model_info", },
  { .offset = 0x00fa0000, .size = 0x00020000, .name = "swupdate_flag", },
  { .offset = 0x00fc0000, .size = 0x00040000, .name = "uboot_env", },
  { .offset = 0x01000000, .size = 0x000a0000, .name = "param", },

  { .offset = 0x010a0000, .size = 0x00040000, .name = "3rdboot_a", },
  { .offset = 0x010e0000, .size = 0x00040000, .name = "uboot_a", },
  { .offset = 0x01120000, .size = 0x00400000, .name = "ucode_a", },
  { .offset = 0x01520000, .size = 0x00400000, .name = "kernel_a", },
  { .offset = 0x01920000, .size = 0x00880000, .name = "rfs_a", },
  { .offset = 0x021a0000, .size = 0x03e80000, .name = "usr_a", },

  { .offset = 0x06020000, .size = 0x00040000, .name = "3rdboot_b", },
  { .offset = 0x06060000, .size = 0x00040000, .name = "uboot_b", },
  { .offset = 0x060a0000, .size = 0x00400000, .name = "ucode_b", },
  { .offset = 0x064a0000, .size = 0x00400000, .name = "kernel_b", },
  { .offset = 0x068a0000, .size = 0x00880000, .name = "rfs_b", },
  { .offset = 0x07120000, .size = 0x03e80000, .name = "usr_b", },

  { .offset = 0x0afa0000, .size = 0x00040000, .name = "3rd", },
  { .offset = 0x0afe0000, .size = 0x01e00000, .name = "sys_data", },
  { .offset = 0x0cde0000, .size = 0x00500000, .name = "usr_data", },
  { .offset = 0x0d2e0000, .size = 0x01e00000, .name = "ro_data", },
  { .offset = 0x0f0e0000, .size = 0x00700000, .name = "tmp", },
  { .offset = 0x0f7e0000, .size = 0x00020000, .name = "manual", },
  { .offset = 0x0f800000, .size = 0x10800000, .name = "sys_bbm", }
};

#if defined(CONFIG_NANDBOOT_BANKCHOICE)
static struct mtd_partition nand_gpbc_partition_info1[] = {
  { .offset = 0x00000000, .size = 0x00100000, .name = "nand_2ndboot", },
  { .offset = 0x00100000, .size = 0x00040000, .name = "v3rdboot", },
  { .offset = 0x00140000, .size = 0x00040000, .name = "vuboot", },
  { .offset = 0x00180000, .size = 0x00400000, .name = "vucode", },
  { .offset = 0x00580000, .size = 0x00a00000, .name = "vkernel", },
  { .offset = 0x00f80000, .size = 0x00020000, .name = "model_info", },
  { .offset = 0x00fa0000, .size = 0x00020000, .name = "swupdate_flag", },
  { .offset = 0x00fc0000, .size = 0x00040000, .name = "uboot_env", },
  { .offset = 0x01000000, .size = 0x000a0000, .name = "param", },

  { .offset = 0x010a0000, .size = 0x00040000, .name = "3rdboot_a", },
  { .offset = 0x010e0000, .size = 0x00040000, .name = "uboot_a", },
  { .offset = 0x01120000, .size = 0x00400000, .name = "ucode_a", },
  { .offset = 0x01520000, .size = 0x00400000, .name = "kernel_a", },
  { .offset = 0x01920000, .size = 0x00880000, .name = "rfs_a", },
  { .offset = 0x021a0000, .size = 0x03e80000, .name = "usr_a", },

  { .offset = 0x06020000, .size = 0x00040000, .name = "3rdboot_b", },
  { .offset = 0x06060000, .size = 0x00040000, .name = "uboot_b", },
  { .offset = 0x060a0000, .size = 0x00400000, .name = "ucode_b", },
  { .offset = 0x064a0000, .size = 0x00400000, .name = "kernel_b", },
  { .offset = 0x068a0000, .size = 0x00880000, .name = "rfs_b", },
  { .offset = 0x07120000, .size = 0x03e80000, .name = "usr_b", },

  { .offset = 0x0afa0000, .size = 0x00040000, .name = "3rd", },
  { .offset = 0x0afe0000, .size = 0x01e00000, .name = "sys_data", },
  { .offset = 0x0cde0000, .size = 0x00500000, .name = "usr_data", },
  { .offset = 0x0d2e0000, .size = 0x01e00000, .name = "ro_data", },
  { .offset = 0x0f0e0000, .size = 0x00700000, .name = "tmp", },
  { .offset = 0x0f7e0000, .size = 0x00020000, .name = "manual", },
  { .offset = 0x0f800000, .size = 0x10800000, .name = "sys_bbm", }
};
#endif

#elif (CONFIG_MTD_NAND_MN2WS_CHIP_SIZE_GBIT==16)
static struct mtd_partition nand_gpbc_partition_info[] = {
  { .offset = 0x00000000, .size = 0x00020000, .name = "nand_2ndboot", },
  { .offset = 0x00020000, .size = 0x00040000, .name = "v3rdboot", },
  { .offset = 0x00060000, .size = 0x00040000, .name = "vuboot", },
  { .offset = 0x000a0000, .size = 0x00800000, .name = "vucode", },
  { .offset = 0x008a0000, .size = 0x00a00000, .name = "vkernel", },
  { .offset = 0x012a0000, .size = 0x00100000, .name = "model_info", },
  { .offset = 0x013a0000, .size = 0x00080000, .name = "swupdate_flag", },
  { .offset = 0x01420000, .size = 0x00040000, .name = "uboot_env", },
  { .offset = 0x01460000, .size = 0x000a0000, .name = "param", },

  { .offset = 0x01500000, .size = 0x00040000, .name = "3rdboot_a", },
  { .offset = 0x01540000, .size = 0x00040000, .name = "uboot_a", },
  { .offset = 0x01580000, .size = 0x00800000, .name = "ucode_a", },
  { .offset = 0x01d80000, .size = 0x00a00000, .name = "kernel_a", },
  { .offset = 0x02780000, .size = 0x00a00000, .name = "rfs_a", },
  { .offset = 0x03180000, .size = 0x05000000, .name = "usr_a", },

  { .offset = 0x08180000, .size = 0x00040000, .name = "3rdboot_b", },
  { .offset = 0x081c0000, .size = 0x00040000, .name = "uboot_b", },
  { .offset = 0x08200000, .size = 0x00800000, .name = "ucode_b", },
  { .offset = 0x08a00000, .size = 0x00a00000, .name = "kernel_b", },
  { .offset = 0x09400000, .size = 0x00a00000, .name = "rfs_b", },
  { .offset = 0x09e00000, .size = 0x05000000, .name = "usr_b", },

  { .offset = 0x0ee00000, .size = 0x06400000, .name = "3rd", },
  { .offset = 0x15200000, .size = 0x01e00000, .name = "sys_data", },
  { .offset = 0x17000000, .size = 0x02800000, .name = "usr_data", },
  { .offset = 0x19800000, .size = 0x01e00000, .name = "ro_data", },
  { .offset = 0x1b600000, .size = 0x00700000, .name = "tmp", },
  { .offset = 0x1bd00000, .size = 0x03300000, .name = "manual", },
#if (CONFIG_MTD_NAND_MN2WS_CHIP_BANK == 1)
  { .offset = 0x1f000000, .size = 0x01000000, .name = "sys_bbm", }

#elif (CONFIG_MTD_NAND_MN2WS_CHIP_BANK == 2) /* only 16Gbit NAND supported */
  { .offset = 0x1f000000, .size = 0x1f000000, .name = "nand_sys_reserved1", },
  { .offset = 0x3e000000, .size = 0x02000000, .name = "nand_sys_bbm1", },
  { .offset = 0x40000000, .size = 0x3e000000, .name = "nand_sys_reserved2", },
  { .offset = 0x7e000000, .size = 0x02000000, .name = "nand_sys_bbm2", },
  #endif
};

#if defined(CONFIG_NANDBOOT_BANKCHOICE)
static struct mtd_partition nand_gpbc_partition_info1[] = {
  { .offset = 0x00000000, .size = 0x00020000, .name = "nand_2ndboot", },
  { .offset = 0x00020000, .size = 0x00040000, .name = "v3rdboot", },
  { .offset = 0x00060000, .size = 0x00040000, .name = "vuboot", },
  { .offset = 0x000a0000, .size = 0x00800000, .name = "vucode", },
  { .offset = 0x008a0000, .size = 0x00a00000, .name = "vkernel", },
  { .offset = 0x012a0000, .size = 0x00100000, .name = "model_info", },
  { .offset = 0x013a0000, .size = 0x00080000, .name = "swupdate_flag", },
  { .offset = 0x01420000, .size = 0x00040000, .name = "uboot_env", },
  { .offset = 0x01460000, .size = 0x000a0000, .name = "param", },

  { .offset = 0x01500000, .size = 0x00040000, .name = "3rdboot_a", },
  { .offset = 0x01540000, .size = 0x00040000, .name = "uboot_a", },
  { .offset = 0x01580000, .size = 0x00800000, .name = "ucode_a", },
  { .offset = 0x01d80000, .size = 0x00a00000, .name = "kernel_a", },
  { .offset = 0x02780000, .size = 0x00a00000, .name = "rfs_a", },
  { .offset = 0x03180000, .size = 0x05000000, .name = "usr_a", },

  { .offset = 0x08180000, .size = 0x00040000, .name = "3rdboot_b", },
  { .offset = 0x081c0000, .size = 0x00040000, .name = "uboot_b", },
  { .offset = 0x08200000, .size = 0x00800000, .name = "ucode_b", },
  { .offset = 0x08a00000, .size = 0x00a00000, .name = "kernel_b", },
  { .offset = 0x09400000, .size = 0x00a00000, .name = "rfs_b", },
  { .offset = 0x09e00000, .size = 0x05000000, .name = "usr_b", },

  { .offset = 0x0ee00000, .size = 0x06400000, .name = "3rd", },
  { .offset = 0x15200000, .size = 0x01e00000, .name = "sys_data", },
  { .offset = 0x17000000, .size = 0x02800000, .name = "usr_data", },
  { .offset = 0x19800000, .size = 0x01e00000, .name = "ro_data", },
  { .offset = 0x1b600000, .size = 0x00700000, .name = "tmp", },
  { .offset = 0x1bd00000, .size = 0x03300000, .name = "manual", },
#if (CONFIG_MTD_NAND_MN2WS_CHIP_BANK == 1)
  { .offset = 0x1f000000, .size = 0x01000000, .name = "sys_bbm", }

#elif (CONFIG_MTD_NAND_MN2WS_CHIP_BANK == 2) /* only 16Gbit NAND supported */
  { .offset = 0x1f000000, .size = 0x1f000000, .name = "nand_sys_reserved1", },
  { .offset = 0x3e000000, .size = 0x02000000, .name = "nand_sys_bbm1", },
  { .offset = 0x40000000, .size = 0x3e000000, .name = "nand_sys_reserved2", },
  { .offset = 0x7e000000, .size = 0x02000000, .name = "nand_sys_bbm2", },
  #endif
};
#endif

#else
# error Unexpected NAND Size !!
#endif


#elif defined(CONFIG_MTD_NAND_MAP_V3)
#if defined(CONFIG_MACH_MN2WS0251_REF) || defined(CONFIG_MACH_MN2WS0270_REF)
#if ((CONFIG_MTD_NAND_MN2WS_CHIP_SIZE_GBIT==0) && (CONFIG_MTD_NAND_MN2WS_CHIP_SIZE_MBIT==512))
/* [V3-MAP SYSTEM] Size=512Mb */
		static struct mtd_partition nand_gpbc_partition_info[] = {
			{ .offset = 0x00000000, .size = 0x00100000, .name = "nand_2ndboot", },
			{ .offset = 0x00100000, .size = 0x00100000, .name = "stm_nand_2ndboot", },
			{ .offset = 0x00200000, .size = 0x00020000, .name = "nand_swupdate_flag1", },
			{ .offset = 0x00220000, .size = 0x00020000, .name = "nand_swupdate_flag2", },
			{ .offset = 0x00240000, .size = 0x00020000, .name = "nand_stm_main", },
			{ .offset = 0x00260000, .size = 0x00040000, .name = "nand_3rdboot", },
			{ .offset = 0x002a0000, .size = 0x00040000, .name = "nand_uboot", },
			{ .offset = 0x002e0000, .size = 0x00700000, .name = "nand_ucode", },
			{ .offset = 0x009e0000, .size = 0x00180000, .name = "nand_kernel", },
			{ .offset = 0x00b60000, .size = 0x00380000, .name = "nand_rootfs", },
			{ .offset = 0x00ee0000, .size = 0x00C00000, .name = "nand_fs_usr", },
			{ .offset = 0x01ae0000, .size = 0x018A0000, .name = "nand_bank1", },
			{ .offset = 0x03380000, .size = 0x00020000, .name = "nand_uboot_env", },
			{ .offset = 0x033a0000, .size = 0x00800000, .name = "nand_fs_nv", },
			{ .offset = 0x03ba0000, .size = 0x03D00000, .name = "nand_fs_usr_extref", },
			{ .offset = 0x078a0000, .size = 0x00040000, .name = "nand_eeprom", },
			{ .offset = 0x078e0000, .size = 0x00720000, .name = "nand_sys_bbm", },
		};
#if defined(CONFIG_NANDBOOT_BANKCHOICE)
		static struct mtd_partition nand_gpbc_partition_info1[] = {
			{ .offset = 0x00000000, .size = 0x00100000, .name = "nand_2ndboot", },
			{ .offset = 0x00100000, .size = 0x00100000, .name = "stm_nand_2ndboot", },
			{ .offset = 0x00200000, .size = 0x00020000, .name = "nand_swupdate_flag1", },
			{ .offset = 0x00220000, .size = 0x00020000, .name = "nand_swupdate_flag2", },
			{ .offset = 0x01ae0000, .size = 0x00020000, .name = "nand_stm_main", },
			{ .offset = 0x01b00000, .size = 0x00040000, .name = "nand_3rdboot", },
			{ .offset = 0x01b40000, .size = 0x00040000, .name = "nand_uboot", },
			{ .offset = 0x01b80000, .size = 0x00700000, .name = "nand_ucode", },
			{ .offset = 0x02280000, .size = 0x00180000, .name = "nand_kernel", },
			{ .offset = 0x02400000, .size = 0x00380000, .name = "nand_rootfs", },
			{ .offset = 0x02780000, .size = 0x00C00000, .name = "nand_fs_usr", },
			{ .offset = 0x00240000, .size = 0x018A0000, .name = "nand_bank1", },
			{ .offset = 0x03380000, .size = 0x00020000, .name = "nand_uboot_env", },
			{ .offset = 0x033a0000, .size = 0x00800000, .name = "nand_fs_nv", },
			{ .offset = 0x03ba0000, .size = 0x03D00000, .name = "nand_fs_usr_extref", },
			{ .offset = 0x078a0000, .size = 0x00040000, .name = "nand_eeprom", },
			{ .offset = 0x078e0000, .size = 0x00720000, .name = "nand_sys_bbm", },
		};
#endif  //defined(CONFIG_NANDBOOT_BANKCHOICE)
#elif (CONFIG_MTD_NAND_MN2WS_CHIP_SIZE_GBIT==1)
/* [V3-MAP SYSTEM] Size=1Gb */
		static struct mtd_partition nand_gpbc_partition_info[] = {
			{ .offset = 0x00000000, .size = 0x00100000, .name = "nand_2ndboot", },
			{ .offset = 0x00100000, .size = 0x00100000, .name = "stm_nand_2ndboot", },
			{ .offset = 0x00200000, .size = 0x00020000, .name = "nand_swupdate_flag1", },
			{ .offset = 0x00220000, .size = 0x00020000, .name = "nand_swupdate_flag2", },
			{ .offset = 0x00240000, .size = 0x00020000, .name = "nand_stm_main", },
			{ .offset = 0x00260000, .size = 0x00040000, .name = "nand_3rdboot", },
			{ .offset = 0x002a0000, .size = 0x00040000, .name = "nand_uboot", },
			{ .offset = 0x002e0000, .size = 0x00700000, .name = "nand_ucode", },
			{ .offset = 0x009e0000, .size = 0x00180000, .name = "nand_kernel", },
			{ .offset = 0x00b60000, .size = 0x00380000, .name = "nand_rootfs", },
			{ .offset = 0x00ee0000, .size = 0x01E00000, .name = "nand_fs_usr", },
			{ .offset = 0x02CE0000, .size = 0x02AA0000, .name = "nand_bank1", },
			{ .offset = 0x05780000, .size = 0x00040000, .name = "nand_uboot_env", },
			{ .offset = 0x057C0000, .size = 0x00800000, .name = "nand_fs_nv", },
			{ .offset = 0x05FC0000, .size = 0x018E0000, .name = "nand_fs_usr_extref", },
			{ .offset = 0x078a0000, .size = 0x00040000, .name = "nand_eeprom", },
			{ .offset = 0x078e0000, .size = 0x00000000, .name = "nand_reserved", },
			{ .offset = 0x078e0000, .size = 0x00720000, .name = "nand_sys_bbm", },
		};
#if defined(CONFIG_NANDBOOT_BANKCHOICE)
		static struct mtd_partition nand_gpbc_partition_info1[] = {
			{ .offset = 0x00000000, .size = 0x00100000, .name = "nand_2ndboot", },
			{ .offset = 0x00100000, .size = 0x00100000, .name = "stm_nand_2ndboot", },
			{ .offset = 0x00200000, .size = 0x00020000, .name = "nand_swupdate_flag1", },
			{ .offset = 0x00220000, .size = 0x00020000, .name = "nand_swupdate_flag2", },
			{ .offset = 0x02CE0000, .size = 0x00020000, .name = "nand_stm_main", },
			{ .offset = 0x02D00000, .size = 0x00040000, .name = "nand_3rdboot", },
			{ .offset = 0x02D40000, .size = 0x00040000, .name = "nand_uboot", },
			{ .offset = 0x02D80000, .size = 0x00700000, .name = "nand_ucode", },
			{ .offset = 0x03480000, .size = 0x00180000, .name = "nand_kernel", },
			{ .offset = 0x03600000, .size = 0x00380000, .name = "nand_rootfs", },
			{ .offset = 0x03980000, .size = 0x01E00000, .name = "nand_fs_usr", },
			{ .offset = 0x00240000, .size = 0x02AA0000, .name = "nand_bank1", },
			{ .offset = 0x05780000, .size = 0x00040000, .name = "nand_uboot_env", },
			{ .offset = 0x057C0000, .size = 0x00800000, .name = "nand_fs_nv", },
			{ .offset = 0x05FC0000, .size = 0x018E0000, .name = "nand_fs_usr_extref", },
			{ .offset = 0x078a0000, .size = 0x00040000, .name = "nand_eeprom", },
			{ .offset = 0x078e0000, .size = 0x00000000, .name = "nand_reserved", },
			{ .offset = 0x078e0000, .size = 0x00720000, .name = "nand_sys_bbm", },
		};
#endif  //defined(CONFIG_NANDBOOT_BANKCHOICE)
#elif (CONFIG_MTD_NAND_MN2WS_CHIP_SIZE_GBIT==2)
/* [V3-MAP SYSTEM] Size=2Gb */
#if 0	/* [TAITEX_ROM_CHG][nv size 8M->40M][160310][START] */
		static struct mtd_partition nand_gpbc_partition_info[] = {
			{ .offset = 0x00000000, .size = 0x00100000, .name = "nand_2ndboot", },
			{ .offset = 0x00100000, .size = 0x00100000, .name = "stm_nand_2ndboot", },
			{ .offset = 0x00200000, .size = 0x00020000, .name = "nand_swupdate_flag1", },
			{ .offset = 0x00220000, .size = 0x00020000, .name = "nand_swupdate_flag2", },
#if 0 /* [TARA_USR_ROM_CHG][nand_fs_usr 12M->30M][151208][START]*/
			{ .offset = 0x00240000, .size = 0x00020000, .name = "nand_stm_main", },
			{ .offset = 0x00260000, .size = 0x00040000, .name = "nand_3rdboot", },
			{ .offset = 0x002a0000, .size = 0x00040000, .name = "nand_uboot", },
			{ .offset = 0x002e0000, .size = 0x00700000, .name = "nand_ucode", },
			{ .offset = 0x009e0000, .size = 0x00180000, .name = "nand_kernel", },
			{ .offset = 0x00b60000, .size = 0x00380000, .name = "nand_rootfs", },
			{ .offset = 0x00ee0000, .size = 0x00C00000, .name = "nand_fs_usr", },
			{ .offset = 0x01ae0000, .size = 0x018A0000, .name = "nand_bank1", },
			{ .offset = 0x03380000, .size = 0x00020000, .name = "nand_uboot_env", },
			{ .offset = 0x033a0000, .size = 0x00800000, .name = "nand_fs_nv", },
			{ .offset = 0x03ba0000, .size = 0x03D00000, .name = "nand_fs_usr_extref", },
#else
			{ .offset = 0x00240000, .size = 0x00020000, .name = "nand_stm_main", },
			{ .offset = 0x00260000, .size = 0x00040000, .name = "nand_3rdboot", },
			{ .offset = 0x002a0000, .size = 0x00040000, .name = "nand_uboot", },
			{ .offset = 0x002e0000, .size = 0x00700000, .name = "nand_ucode", },
			{ .offset = 0x009e0000, .size = 0x00180000, .name = "nand_kernel", },
			{ .offset = 0x00b60000, .size = 0x00380000, .name = "nand_rootfs", },
			{ .offset = 0x00ee0000, .size = 0x01E00000, .name = "nand_fs_usr", },
			{ .offset = 0x02CE0000, .size = 0x02AA0000, .name = "nand_bank1", },
			{ .offset = 0x05780000, .size = 0x00040000, .name = "nand_uboot_env", },
			{ .offset = 0x057C0000, .size = 0x00800000, .name = "nand_fs_nv", },
			{ .offset = 0x05FC0000, .size = 0x018E0000, .name = "nand_fs_usr_extref", },
#endif /* [TARA_USR_ROM_CHG][nand_fs_usr 12M->30M][151208][END]*/
			{ .offset = 0x078a0000, .size = 0x00040000, .name = "nand_eeprom", },
#if defined(CONFIG_OPTION_TKS_FL12)
			{ .offset = 0x078e0000, .size = 0x00500000, .name = "nand_fs_nv2", },
			{ .offset = 0x07de0000, .size = 0x075E0000, .name = "nand_reserved", },
#else
			{ .offset = 0x078e0000, .size = 0x07AE0000, .name = "nand_reserved", },
#endif //defined(CONFIG_OPTION_TKS_FL12)
			{ .offset = 0x0f3c0000, .size = 0x00C40000, .name = "nand_sys_bbm", },
		};
#else	/* nv size 8M->40M */
		static struct mtd_partition nand_gpbc_partition_info[] = {
			{ .offset = 0x00000000, .size = 0x00100000, .name = "nand_2ndboot", },
			{ .offset = 0x00100000, .size = 0x00100000, .name = "stm_nand_2ndboot", },
			{ .offset = 0x00200000, .size = 0x00020000, .name = "nand_swupdate_flag1", },
			{ .offset = 0x00220000, .size = 0x00020000, .name = "nand_swupdate_flag2", },
			{ .offset = 0x00240000, .size = 0x00020000, .name = "nand_stm_main", },
			{ .offset = 0x00260000, .size = 0x00040000, .name = "nand_3rdboot", },
			{ .offset = 0x002a0000, .size = 0x00040000, .name = "nand_uboot", },
			{ .offset = 0x002e0000, .size = 0x00700000, .name = "nand_ucode", },
			{ .offset = 0x009e0000, .size = 0x00180000, .name = "nand_kernel", },
			{ .offset = 0x00b60000, .size = 0x00380000, .name = "nand_rootfs", },
			{ .offset = 0x00ee0000, .size = 0x01E00000, .name = "nand_fs_usr", },
			{ .offset = 0x02CE0000, .size = 0x02AA0000, .name = "nand_bank1", },
			{ .offset = 0x05780000, .size = 0x00040000, .name = "nand_uboot_env", },
			{ .offset = 0x057C0000, .size = 0x02800000, .name = "nand_fs_nv", },
			{ .offset = 0x07FC0000, .size = 0x018E0000, .name = "nand_fs_usr_extref", },
			{ .offset = 0x098a0000, .size = 0x00040000, .name = "nand_eeprom", },
			{ .offset = 0x098e0000, .size = 0x05AE0000, .name = "nand_reserved", },
			{ .offset = 0x0f3c0000, .size = 0x00C40000, .name = "nand_sys_bbm", },
		};
#endif		/* [TAITEX_ROM_CHG][nv size 8M->40M][160310][END] */
#if defined(CONFIG_NANDBOOT_BANKCHOICE)
#if 0	/* [TAITEX_ROM_CHG][nv size 8M->40M][160310][START] */
		static struct mtd_partition nand_gpbc_partition_info1[] = {
			{ .offset = 0x00000000, .size = 0x00100000, .name = "nand_2ndboot", },
			{ .offset = 0x00100000, .size = 0x00100000, .name = "stm_nand_2ndboot", },
			{ .offset = 0x00200000, .size = 0x00020000, .name = "nand_swupdate_flag1", },
			{ .offset = 0x00220000, .size = 0x00020000, .name = "nand_swupdate_flag2", },
#if 0 /* [TARA_USR_ROM_CHG][nand_fs_usr 12M->30M][151208][START]*/
			{ .offset = 0x01ae0000, .size = 0x00020000, .name = "nand_stm_main", },
			{ .offset = 0x01b00000, .size = 0x00040000, .name = "nand_3rdboot", },
			{ .offset = 0x01b40000, .size = 0x00040000, .name = "nand_uboot", },
			{ .offset = 0x01b80000, .size = 0x00700000, .name = "nand_ucode", },
			{ .offset = 0x02280000, .size = 0x00180000, .name = "nand_kernel", },
			{ .offset = 0x02400000, .size = 0x00380000, .name = "nand_rootfs", },
			{ .offset = 0x02780000, .size = 0x00C00000, .name = "nand_fs_usr", },
			{ .offset = 0x00240000, .size = 0x018A0000, .name = "nand_bank1", },
			{ .offset = 0x03380000, .size = 0x00020000, .name = "nand_uboot_env", },
			{ .offset = 0x033a0000, .size = 0x00800000, .name = "nand_fs_nv", },
			{ .offset = 0x03ba0000, .size = 0x03D00000, .name = "nand_fs_usr_extref", },
#else
			{ .offset = 0x02CE0000, .size = 0x00020000, .name = "nand_stm_main", },
			{ .offset = 0x02D00000, .size = 0x00040000, .name = "nand_3rdboot", },
			{ .offset = 0x02D40000, .size = 0x00040000, .name = "nand_uboot", },
			{ .offset = 0x02D80000, .size = 0x00700000, .name = "nand_ucode", },
			{ .offset = 0x03480000, .size = 0x00180000, .name = "nand_kernel", },
			{ .offset = 0x03600000, .size = 0x00380000, .name = "nand_rootfs", },
			{ .offset = 0x03980000, .size = 0x01E00000, .name = "nand_fs_usr", },
			{ .offset = 0x00240000, .size = 0x02AA0000, .name = "nand_bank1", },
			{ .offset = 0x05780000, .size = 0x00040000, .name = "nand_uboot_env", },
			{ .offset = 0x057C0000, .size = 0x00800000, .name = "nand_fs_nv", },
			{ .offset = 0x05FC0000, .size = 0x018E0000, .name = "nand_fs_usr_extref", },
#endif/* [TARA_USR_ROM_CHG][nand_fs_usr 12M->30M][151208][END]*/
			{ .offset = 0x078a0000, .size = 0x00040000, .name = "nand_eeprom", },
#if defined(CONFIG_OPTION_TKS_FL12)
			{ .offset = 0x078e0000, .size = 0x00500000, .name = "nand_fs_nv2", },
			{ .offset = 0x07de0000, .size = 0x075E0000, .name = "nand_reserved", },
#else
			{ .offset = 0x078e0000, .size = 0x07AE0000, .name = "nand_reserved", },
#endif //defined(CONFIG_OPTION_TKS_FL12)
			{ .offset = 0x0f3c0000, .size = 0x00C40000, .name = "nand_sys_bbm", },
		};
#else	/* nv size 8M->40M */
		static struct mtd_partition nand_gpbc_partition_info1[] = {
			{ .offset = 0x00000000, .size = 0x00100000, .name = "nand_2ndboot", },
			{ .offset = 0x00100000, .size = 0x00100000, .name = "stm_nand_2ndboot", },
			{ .offset = 0x00200000, .size = 0x00020000, .name = "nand_swupdate_flag1", },
			{ .offset = 0x00220000, .size = 0x00020000, .name = "nand_swupdate_flag2", },
			{ .offset = 0x02CE0000, .size = 0x00020000, .name = "nand_stm_main", },
			{ .offset = 0x02D00000, .size = 0x00040000, .name = "nand_3rdboot", },
			{ .offset = 0x02D40000, .size = 0x00040000, .name = "nand_uboot", },
			{ .offset = 0x02D80000, .size = 0x00700000, .name = "nand_ucode", },
			{ .offset = 0x03480000, .size = 0x00180000, .name = "nand_kernel", },
			{ .offset = 0x03600000, .size = 0x00380000, .name = "nand_rootfs", },
			{ .offset = 0x03980000, .size = 0x01E00000, .name = "nand_fs_usr", },
			{ .offset = 0x00240000, .size = 0x02AA0000, .name = "nand_bank1", },
			{ .offset = 0x05780000, .size = 0x00040000, .name = "nand_uboot_env", },
			{ .offset = 0x057C0000, .size = 0x02800000, .name = "nand_fs_nv", },
			{ .offset = 0x07FC0000, .size = 0x018E0000, .name = "nand_fs_usr_extref", },
			{ .offset = 0x098a0000, .size = 0x00040000, .name = "nand_eeprom", },
			{ .offset = 0x098e0000, .size = 0x05AE0000, .name = "nand_reserved", },
			{ .offset = 0x0f3c0000, .size = 0x00C40000, .name = "nand_sys_bbm", },
		};

#endif		/* [TAITEX_ROM_CHG][nv size 8M->40M][160310][END] */
#endif  //defined(CONFIG_NANDBOOT_BANKCHOICE)
#elif (CONFIG_MTD_NAND_MN2WS_CHIP_SIZE_GBIT==4)
/* [V3-MAP SYSTEM] Size=4Gb */
		static struct mtd_partition nand_gpbc_partition_info[] = {
			{ .offset = 0x00000000, .size = 0x00100000, .name = "nand_2ndboot", },
			{ .offset = 0x00100000, .size = 0x00100000, .name = "stm_nand_2ndboot", },
			{ .offset = 0x00200000, .size = 0x00020000, .name = "nand_swupdate_flag1", },
			{ .offset = 0x00220000, .size = 0x00020000, .name = "nand_swupdate_flag2", },
			{ .offset = 0x00240000, .size = 0x00020000, .name = "nand_stm_main", },
			{ .offset = 0x00260000, .size = 0x00040000, .name = "nand_3rdboot", },
			{ .offset = 0x002a0000, .size = 0x00040000, .name = "nand_uboot", },
			{ .offset = 0x002e0000, .size = 0x00700000, .name = "nand_ucode", },
			{ .offset = 0x009e0000, .size = 0x00180000, .name = "nand_kernel", },
			{ .offset = 0x00b60000, .size = 0x00380000, .name = "nand_rootfs", },
			{ .offset = 0x00ee0000, .size = 0x00C00000, .name = "nand_fs_usr", },
			{ .offset = 0x01ae0000, .size = 0x018A0000, .name = "nand_bank1", },
			{ .offset = 0x03380000, .size = 0x00020000, .name = "nand_uboot_env", },
			{ .offset = 0x033a0000, .size = 0x00800000, .name = "nand_fs_nv", },
			{ .offset = 0x03ba0000, .size = 0x03D00000, .name = "nand_fs_usr_extref", },
			{ .offset = 0x078a0000, .size = 0x00040000, .name = "nand_eeprom", },
#if defined(CONFIG_OPTION_TKS_FL12)
			{ .offset = 0x078e0000, .size = 0x00500000, .name = "nand_fs_nv2", },
			{ .offset = 0x07de0000, .size = 0x175E0000, .name = "nand_reserved", },
#else
			{ .offset = 0x078e0000, .size = 0x17AE0000, .name = "nand_reserved", },
#endif //defined(CONFIG_OPTION_TKS_FL12)
			{ .offset = 0x1f3c0000, .size = 0x00C40000, .name = "nand_sys_bbm", },
		};
#if defined(CONFIG_NANDBOOT_BANKCHOICE)
		static struct mtd_partition nand_gpbc_partition_info1[] = {
			{ .offset = 0x00000000, .size = 0x00100000, .name = "nand_2ndboot", },
			{ .offset = 0x00100000, .size = 0x00100000, .name = "stm_nand_2ndboot", },
			{ .offset = 0x00200000, .size = 0x00020000, .name = "nand_swupdate_flag1", },
			{ .offset = 0x00220000, .size = 0x00020000, .name = "nand_swupdate_flag2", },
			{ .offset = 0x01ae0000, .size = 0x00020000, .name = "nand_stm_main", },
			{ .offset = 0x01b00000, .size = 0x00040000, .name = "nand_3rdboot", },
			{ .offset = 0x01b40000, .size = 0x00040000, .name = "nand_uboot", },
			{ .offset = 0x01b80000, .size = 0x00700000, .name = "nand_ucode", },
			{ .offset = 0x02280000, .size = 0x00180000, .name = "nand_kernel", },
			{ .offset = 0x02400000, .size = 0x00380000, .name = "nand_rootfs", },
			{ .offset = 0x02780000, .size = 0x00C00000, .name = "nand_fs_usr", },
			{ .offset = 0x00240000, .size = 0x018A0000, .name = "nand_bank1", },
			{ .offset = 0x03380000, .size = 0x00020000, .name = "nand_uboot_env", },
			{ .offset = 0x033a0000, .size = 0x00800000, .name = "nand_fs_nv", },
			{ .offset = 0x03ba0000, .size = 0x03D00000, .name = "nand_fs_usr_extref", },
			{ .offset = 0x078a0000, .size = 0x00040000, .name = "nand_eeprom", },
#if defined(CONFIG_OPTION_TKS_FL12)
			{ .offset = 0x078e0000, .size = 0x00500000, .name = "nand_fs_nv2", },
			{ .offset = 0x07de0000, .size = 0x175E0000, .name = "nand_reserved", },
#else
			{ .offset = 0x078e0000, .size = 0x17AE0000, .name = "nand_reserved", },
#endif //defined(CONFIG_OPTION_TKS_FL12)
			{ .offset = 0x1f3c0000, .size = 0x00C40000, .name = "nand_sys_bbm", },
		};
#endif  //defined(CONFIG_NANDBOOT_BANKCHOICE)
#elif (CONFIG_MTD_NAND_MN2WS_CHIP_SIZE_GBIT==16)
/* [V3-MAP SYSTEM] Size=16Gb */
		static struct mtd_partition nand_gpbc_partition_info[] = {
			{ .offset = 0x00000000, .size = 0x00200000, .name = "nand_2ndboot", },
			{ .offset = 0x00200000, .size = 0x00200000, .name = "stm_nand_2ndboot", },
			{ .offset = 0x00400000, .size = 0x00040000, .name = "nand_swupdate_flag1", },
			{ .offset = 0x00440000, .size = 0x00040000, .name = "nand_swupdate_flag2", },
			{ .offset = 0x00480000, .size = 0x00040000, .name = "nand_stm_main", },
			{ .offset = 0x004c0000, .size = 0x00080000, .name = "nand_3rdboot", },
			{ .offset = 0x00540000, .size = 0x00080000, .name = "nand_uboot", },
			{ .offset = 0x005c0000, .size = 0x00700000, .name = "nand_ucode", },
			{ .offset = 0x00cc0000, .size = 0x00180000, .name = "nand_kernel", },
			{ .offset = 0x00e40000, .size = 0x00380000, .name = "nand_rootfs", },
	#if 0	/* [TARA_USR_ROM_CHG][nand_fs_usr 12M->30M][20150920][START]*/
			{ .offset = 0x011c0000, .size = 0x00C00000, .name = "nand_fs_usr", },
			{ .offset = 0x01dc0000, .size = 0x01940000, .name = "nand_bank1", },
			{ .offset = 0x03700000, .size = 0x00040000, .name = "nand_uboot_env", },
			{ .offset = 0x03740000, .size = 0x00800000, .name = "nand_fs_nv", },
			{ .offset = 0x03f40000, .size = 0x03D00000, .name = "nand_fs_usr_extref", },
	#else
			{ .offset = 0x011c0000, .size = 0x01E00000, .name = "nand_fs_usr", },
			{ .offset = 0x02fc0000, .size = 0x02B40000, .name = "nand_bank1", },
			{ .offset = 0x05b00000, .size = 0x00040000, .name = "nand_uboot_env", },
			{ .offset = 0x05b40000, .size = 0x00800000, .name = "nand_fs_nv", },
			{ .offset = 0x06340000, .size = 0x01900000, .name = "nand_fs_usr_extref", },
	#endif	/* [TARA_USR_ROM_CHG][nand_fs_usr 12M->30M][END]*/
			{ .offset = 0x07c40000, .size = 0x00040000, .name = "nand_eeprom", },
#if defined(CONFIG_OPTION_TKS_FL12)
			{ .offset = 0x07c80000, .size = 0x00500000, .name = "nand_fs_nv2", },
			{ .offset = 0x08180000, .size = 0x35E80000, .name = "nand_reserved", },
#else
			{ .offset = 0x07c80000, .size = 0x36380000, .name = "nand_reserved", },
#endif //defined(CONFIG_OPTION_TKS_FL12)
			{ .offset = 0x3e000000, .size = 0x02000000, .name = "nand_sys_bbm", },
#if (CONFIG_MTD_NAND_MN2WS_CHIP_BANK == 2)
			{ .offset = 0x40000000, .size = 0x3E000000, .name = "nand_sys_reserved", },
			{ .offset = 0x7e000000, .size = 0x02000000, .name = "nand_sys_bbm2", },
#endif
		};
#if defined(CONFIG_NANDBOOT_BANKCHOICE)
		static struct mtd_partition nand_gpbc_partition_info1[] = {
			{ .offset = 0x00000000, .size = 0x00200000, .name = "nand_2ndboot", },
			{ .offset = 0x00200000, .size = 0x00200000, .name = "stm_nand_2ndboot", },
			{ .offset = 0x00400000, .size = 0x00040000, .name = "nand_swupdate_flag1", },
			{ .offset = 0x00440000, .size = 0x00040000, .name = "nand_swupdate_flag2", },
	#if 0	/* [TARA_USR_ROM_CHG][nand_fs_usr 12M->30M][START]*/
			{ .offset = 0x01dc0000, .size = 0x00040000, .name = "nand_stm_main", },
			{ .offset = 0x01e00000, .size = 0x00080000, .name = "nand_3rdboot", },
			{ .offset = 0x01e80000, .size = 0x00080000, .name = "nand_uboot", },
			{ .offset = 0x01f00000, .size = 0x00700000, .name = "nand_ucode", },
			{ .offset = 0x02600000, .size = 0x00180000, .name = "nand_kernel", },
			{ .offset = 0x02780000, .size = 0x00380000, .name = "nand_rootfs", },
			{ .offset = 0x02b00000, .size = 0x00C00000, .name = "nand_fs_usr", },
			{ .offset = 0x00480000, .size = 0x01940000, .name = "nand_bank1", },
			{ .offset = 0x03700000, .size = 0x00040000, .name = "nand_uboot_env", },
			{ .offset = 0x03740000, .size = 0x00800000, .name = "nand_fs_nv", },
			{ .offset = 0x03f40000, .size = 0x03D00000, .name = "nand_fs_usr_extref", },
	#else
			{ .offset = 0x02fc0000, .size = 0x00040000, .name = "nand_stm_main", },
			{ .offset = 0x03000000, .size = 0x00080000, .name = "nand_3rdboot", },
			{ .offset = 0x03080000, .size = 0x00080000, .name = "nand_uboot", },
			{ .offset = 0x03100000, .size = 0x00700000, .name = "nand_ucode", },
			{ .offset = 0x03800000, .size = 0x00180000, .name = "nand_kernel", },
			{ .offset = 0x03980000, .size = 0x00380000, .name = "nand_rootfs", },
			{ .offset = 0x03d00000, .size = 0x01E00000, .name = "nand_fs_usr", },
			{ .offset = 0x00480000, .size = 0x02B40000, .name = "nand_bank1", },
			{ .offset = 0x05b00000, .size = 0x00040000, .name = "nand_uboot_env", },
			{ .offset = 0x05b40000, .size = 0x00800000, .name = "nand_fs_nv", },
			{ .offset = 0x06340000, .size = 0x01900000, .name = "nand_fs_usr_extref", },
	#endif	/* [TARA_USR_ROM_CHG][nand_fs_usr 12M->30M][END]*/
			{ .offset = 0x07c40000, .size = 0x00040000, .name = "nand_eeprom", },
#if defined(CONFIG_OPTION_TKS_FL12)
			{ .offset = 0x07c80000, .size = 0x00500000, .name = "nand_fs_nv2", },
			{ .offset = 0x08180000, .size = 0x35E80000, .name = "nand_reserved", },
#else
			{ .offset = 0x07c80000, .size = 0x36380000, .name = "nand_reserved", },
#endif //defined(CONFIG_OPTION_TKS_FL12)
			{ .offset = 0x3e000000, .size = 0x02000000, .name = "nand_sys_bbm", },
#if (CONFIG_MTD_NAND_MN2WS_CHIP_BANK == 2)
			{ .offset = 0x40000000, .size = 0x3E000000, .name = "nand_sys_reserved", },
			{ .offset = 0x7e000000, .size = 0x02000000, .name = "nand_sys_bbm2", },
#endif
		};
#endif  //defined(CONFIG_NANDBOOT_BANKCHOICE)

#else
# error Unexpected NAND Size !!
#endif

#else  //defined(CONFIG_MACH_MN2WS0251_REF || defined(CONFIG_MACH_MN2WS0270_REF)
		static struct mtd_partition nand_gpbc_partition_info[] = {
			{ .offset = 0x00000000, .size = 0x00040000, .name = "nand_2ndboot", },
			{ .offset = 0x00040000, .size = 0x000C0000, .name = "nand_3rdboot", },
			{ .offset = 0x00100000, .size = 0x000C0000, .name = "nand_uboot", },
			{ .offset = 0x001c0000, .size = 0x00040000, .name = "nand_uboot_env", },
			{ .offset = 0x00200000, .size = 0x00A00000, .name = "nand_ucode", },
			{ .offset = 0x00c00000, .size = 0x00400000, .name = "nand_kernel", },
			{ .offset = 0x01000000, .size = 0x01000000, .name = "nand_rootfs", },
			{ .offset = 0x02000000, .size = 0x08000000, .name = "nand_fs_usr", },
			{ .offset = 0x0a000000, .size = 0x04000000, .name = "nand_fs_home", },
			{ .offset = 0x0e000000, .size = 0x04000000, .name = "nand_fs_nv", },
			{ .offset = 0x12000000, .size = 0x2B500000, .name = "nand_fs_reserved", },
			{ .offset = 0x3d500000, .size = 0x00100000, .name = "nand_fs_channel", },
			{ .offset = 0x3d600000, .size = 0x00100000, .name = "nand_misc", },
			{ .offset = 0x3d700000, .size = 0x00900000, .name = "nand_splashscreen", },
			{ .offset = 0x3e000000, .size = 0x02000000, .name = "nand_sys_bbm1", },
#if (CONFIG_MTD_NAND_MN2WS_CHIP_BANK == 2)
			{ .offset = 0x40000000, .size = 0x3E000000, .name = "nand_sys_reserved", },
			{ .offset = 0x7e000000, .size = 0x02000000, .name = "nand_sys_bbm2", },
#endif
		};
#endif //defined(CONFIG_MACH_MN2WS0251_REF || defined(CONFIG_MACH_MN2WS0270_REF)



#else	//defined(CONFIG_MTD_NAND_MAP_V1) elif defined(CONFIG_MTD_NAND_MAP_V2) elif defined(CONFIG_MTD_NAND_MAP_V3)
# error Unknown NAND MAP version !!
#endif	//defined(CONFIG_MTD_NAND_MAP_V1) elif defined(CONFIG_MTD_NAND_MAP_V2) elif defined(CONFIG_MTD_NAND_MAP_V3)

#endif

